<?php
/*
Plugin Name: Leasing Kalkulator dla STM Motors
Plugin URI: https://twojastrona.pl
Description: Wtyczka dodaje kalkulator leasingu do ogłoszeń w motywie STM Motors.
Version: 1.8
Author: Twoje Imię
Author URI: https://twojastrona.pl
License: GPL2
*/

// Dodanie sekcji "Finansowanie" w edycji ogłoszenia
function add_financing_meta_box() {
    add_meta_box('stm_financing_options', 'Finansowanie', 'display_financing_meta_box', 'listings', 'normal', 'high');
}
add_action('add_meta_boxes', 'add_financing_meta_box');

// Wyświetlanie pól w edycji ogłoszenia
function display_financing_meta_box($post) {
    $financing_variants = get_post_meta($post->ID, '_financing_variants', true);
    $variants = $financing_variants ? json_decode($financing_variants, true) : [];
    ?>
    <div id="financing-variants">
        <?php foreach ($variants as $index => $variant) { ?>
            <div class="financing-variant">
                <p>
                    <label>Okres (miesiące):</label>
                    <input type="number" name="financing_variants[<?php echo $index; ?>][period]" value="<?php echo esc_attr($variant['period']); ?>">
                </p>
                <p>
                    <label>Przebieg (km):</label>
                    <input type="number" name="financing_variants[<?php echo $index; ?>][mileage]" value="<?php echo esc_attr($variant['mileage']); ?>">
                </p>
                <p>
                    <label>Rata (zł):</label>
                    <input type="number" name="financing_variants[<?php echo $index; ?>][payment]" value="<?php echo esc_attr($variant['payment']); ?>">
                </p>
            </div>
        <?php } ?>
    </div>
    <button type="button" id="add-financing-variant">Dodaj wariant</button>
    <script>
        document.getElementById('add-financing-variant').addEventListener('click', function() {
            let container = document.getElementById('financing-variants');
            let index = container.children.length;
            let div = document.createElement('div');
            div.className = 'financing-variant';
            div.innerHTML = `
                <p><label>Okres (miesiące):</label><input type="number" name="financing_variants[${index}][period]" value=""></p>
                <p><label>Przebieg (km):</label><input type="number" name="financing_variants[${index}][mileage]" value=""></p>
                <p><label>Rata (zł):</label><input type="number" name="financing_variants[${index}][payment]" value=""></p>
            `;
            container.appendChild(div);
        });
    </script>
    <?php
}

// Zapis danych
function save_financing_meta($post_id) {
    if (isset($_POST['financing_variants'])) {
        update_post_meta($post_id, '_financing_variants', json_encode($_POST['financing_variants']));
    }
}
add_action('save_post', 'save_financing_meta');

// Funkcja shortcode dla Elementora
function financing_calculator_shortcode() {
    $financing_variants = get_post_meta(get_the_ID(), '_financing_variants', true);
    $variants = $financing_variants ? json_decode($financing_variants, true) : [];
    
    if (empty($variants)) return '';
    
    ob_start(); ?>
    <div id="financing-calculator">
        <label>Okres finansowania:</label>
        <input type="range" id="rental-period" min="<?php echo min(array_column($variants, 'period')); ?>" max="<?php echo max(array_column($variants, 'period')); ?>" step="12" value="<?php echo min(array_column($variants, 'period')); ?>">
        <span id="rental-period-value"></span>
        <br>
        <label>Limit przebiegu:</label>
        <input type="range" id="mileage-limit" min="<?php echo min(array_column($variants, 'mileage')); ?>" max="<?php echo max(array_column($variants, 'mileage')); ?>" step="5000" value="<?php echo min(array_column($variants, 'mileage')); ?>">
        <span id="mileage-limit-value"></span>
        <br>
        <h4>Miesięczna rata: <span id="monthly-payment"></span> zł</h4>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            let variants = <?php echo json_encode($variants); ?>;
            let rentalPeriodInput = document.getElementById('rental-period');
            let mileageLimitInput = document.getElementById('mileage-limit');
            let monthlyPayment = document.getElementById('monthly-payment');
            let rentalPeriodValue = document.getElementById('rental-period-value');
            let mileageLimitValue = document.getElementById('mileage-limit-value');
            
            function updatePrice() {
                let selectedPeriod = rentalPeriodInput.value;
                let selectedMileage = mileageLimitInput.value;
                let matchedOption = variants.find(o => o.period == selectedPeriod && o.mileage == selectedMileage);
                monthlyPayment.innerText = matchedOption ? matchedOption.payment : 'N/A';
                rentalPeriodValue.innerText = selectedPeriod + ' miesięcy';
                mileageLimitValue.innerText = selectedMileage + ' km';
            }
            
            rentalPeriodInput.addEventListener('input', updatePrice);
            mileageLimitInput.addEventListener('input', updatePrice);
            updatePrice();
        });
    </script>
    <?php return ob_get_clean();
}
add_shortcode('leasing_kalkulator', 'financing_calculator_shortcode');
